<?php

function admin_login(PDO $db, $email, $password) {
  $stmt = $db->prepare("SELECT * FROM admin_users WHERE email=?");
  $stmt->execute([$email]);
  $u = $stmt->fetch();
  if ($u && password_verify($password, $u['pass_hash'])) {
    $_SESSION['admin_id'] = $u['id'];
    $_SESSION['admin_email'] = $u['email'];
    $_SESSION['admin_role'] = $u['role'];
    return true;
  }
  return false;
}

function admin_logout() {
  unset($_SESSION['admin_id'], $_SESSION['admin_email'], $_SESSION['admin_role']);
}

function admin_require() {
  if (empty($_SESSION['admin_id'])) {
    header('Location: /admin/login');
    exit;
  }
}
