<?php

function h($str) {
  return htmlspecialchars((string)$str, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

function url_current_base($config) {
  if (!empty($config['base_url'])) return rtrim($config['base_url'], '/');
  $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  return $scheme . '://' . $host;
}

function redirect($path) {
  header('Location: ' . $path);
  exit;
}

function csrf_token($config) {
  $key = $config['csrf_key'] ?? 'csrf_token';
  if (empty($_SESSION[$key])) {
    $_SESSION[$key] = bin2hex(random_bytes(32));
  }
  return $_SESSION[$key];
}

function csrf_check($config) {
  $key = $config['csrf_key'] ?? 'csrf_token';
  $token = $_POST['_csrf'] ?? '';
  return !empty($_SESSION[$key]) && hash_equals($_SESSION[$key], $token);
}

function flash_set($key, $value) {
  $_SESSION['_flash'][$key] = $value;
}

function flash_get($key) {
  $v = $_SESSION['_flash'][$key] ?? null;
  if (isset($_SESSION['_flash'][$key])) unset($_SESSION['_flash'][$key]);
  return $v;
}

function money_ars($n) {
  $n = (float)$n;
  return '$' . number_format($n, 0, ',', '.');
}

function slugify($text) {
  $text = (string)$text;
  $text = iconv('UTF-8', 'ASCII//TRANSLIT', $text);
  $text = preg_replace('~[^\\pL\\d]+~u', '-', $text);
  $text = trim($text, '-');
  $text = preg_replace('~[^-\\w]+~', '', $text);
  $text = strtolower($text);
  return $text ?: 'item';
}

function require_post() {
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
    http_response_code(405);
    echo "Method Not Allowed";
    exit;
  }
}

function json_response($data, $status=200) {
  http_response_code($status);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  exit;
}
