<?php

function route($method, $path, $handler) {
  global $ROUTES;
  $ROUTES[] = [$method, $path, $handler];
}

function dispatch($method, $uri) {
  global $ROUTES;
  $path = parse_url($uri, PHP_URL_PATH);
  // Normalize trailing slash (except root)
  if ($path !== '/' && str_ends_with($path, '/')) $path = rtrim($path, '/');

  foreach ($ROUTES as [$m, $p, $h]) {
    if (strtoupper($m) !== strtoupper($method)) continue;

    // Exact match
    if ($p === $path) return $h([]);

    // Param match e.g. /p/{slug}
    $regex = preg_replace('#\{([a-zA-Z_][a-zA-Z0-9_]*)\}#', '(?P<$1>[^/]+)', $p);
    $regex = '#^' . $regex . '$#';
    if (preg_match($regex, $path, $matches)) {
      $params = [];
      foreach ($matches as $k=>$v) if (!is_int($k)) $params[$k] = $v;
      return $h($params);
    }
  }

  http_response_code(404);
  echo "404 - Not Found";
  exit;
}
