<?php $title = 'Pedido ' . $o['code'] . ' - ' . $config['app_name']; include __DIR__ . '/_head.php'; ?>
<?php include __DIR__ . '/_top.php'; ?>

<main class="container page">
  <div class="page-head">
    <h1>Pedido <?= h($o['code']) ?></h1>
    <a class="btn btn-ghost" href="/admin/orders">Volver</a>
  </div>

  <?php if ($ok = flash_get('ok')): ?>
    <div class="alert"><?= h($ok) ?></div>
  <?php endif; ?>

  <div class="grid2">
    <div class="panel">
      <div class="panel-title">Cliente</div>
      <div><b><?= h($o['customer_name'] ?: '-') ?></b></div>
      <div class="muted"><?= h($o['customer_email'] ?: '-') ?></div>
      <div class="muted"><?= h($o['customer_phone'] ?: '-') ?></div>
      <div class="muted"><?= nl2br(h($o['shipping_address'] ?: '-')) ?></div>
      <div class="muted"><?= nl2br(h($o['notes'] ?: '')) ?></div>
    </div>

    <div class="panel">
      <div class="panel-title">Estado</div>
      <form method="post" action="/admin/orders/status" class="row">
        <input type="hidden" name="_csrf" value="<?= h(csrf_token($config)) ?>">
        <input type="hidden" name="id" value="<?= (int)$o['id'] ?>">
        <select class="input" name="status">
          <?php foreach (['new','paid','shipped','cancelled'] as $s): ?>
            <option value="<?= h($s) ?>" <?= $o['status']===$s?'selected':'' ?>><?= h($s) ?></option>
          <?php endforeach; ?>
        </select>
        <button class="btn" type="submit">Guardar</button>
      </form>
      <div class="sum-row total"><span>Total</span><span><?= h(money_ars($o['total'])) ?></span></div>
    </div>
  </div>

  <div class="panel">
    <div class="panel-title">Items</div>
    <div class="table">
      <div class="tr th"><div>Producto</div><div>Cant.</div><div>Precio</div><div>Total</div></div>
      <?php foreach ($items as $it): ?>
        <div class="tr">
          <div><?= h($it['name']) ?></div>
          <div><?= (int)$it['qty'] ?></div>
          <div><?= h(money_ars($it['unit_price'])) ?></div>
          <div><?= h(money_ars($it['line_total'])) ?></div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</main>

<?php include __DIR__ . '/../partials/footer.php'; ?>
