<?php $title = 'Pedidos - ' . $config['app_name']; include __DIR__ . '/_head.php'; ?>
<?php include __DIR__ . '/_top.php'; ?>

<main class="container page">
  <h1>Pedidos</h1>

  <?php if ($ok = flash_get('ok')): ?>
    <div class="alert"><?= h($ok) ?></div>
  <?php endif; ?>

  <div class="table">
    <div class="tr th">
      <div>Fecha</div><div>Código</div><div>Cliente</div><div>Total</div><div>Estado</div><div></div>
    </div>
    <?php foreach ($orders as $o): ?>
      <div class="tr">
        <div class="muted"><?= h(substr($o['created_at'],0,10)) ?></div>
        <div class="strong"><?= h($o['code']) ?></div>
        <div><?= h($o['customer_name'] ?: '-') ?></div>
        <div><?= h(money_ars($o['total'])) ?></div>
        <div><span class="pill"><?= h($o['status']) ?></span></div>
        <div><a class="link" href="/admin/orders/<?= (int)$o['id'] ?>">Ver</a></div>
      </div>
    <?php endforeach; ?>
  </div>
</main>

<?php include __DIR__ . '/../partials/footer.php'; ?>
