<?php $title = ($p['id'] ? 'Editar' : 'Nuevo') . ' producto - ' . $config['app_name']; include __DIR__ . '/_head.php'; ?>
<?php include __DIR__ . '/_top.php'; ?>

<main class="container page">
  <div class="page-head">
    <h1><?= $p['id'] ? 'Editar producto' : 'Nuevo producto' ?></h1>
    <a class="btn btn-ghost" href="/admin/products">Volver</a>
  </div>

  <?php if ($ok = flash_get('ok')): ?>
    <div class="alert"><?= h($ok) ?></div>
  <?php endif; ?>

  <form method="post" action="/admin/products/save">
    <input type="hidden" name="_csrf" value="<?= h(csrf_token($config)) ?>">
    <input type="hidden" name="id" value="<?= (int)($p['id'] ?? 0) ?>">

    <div class="grid2">
      <div>
        <label class="label">Nombre</label>
        <input class="input" name="name" value="<?= h($p['name'] ?? '') ?>" required>

        <label class="label">Slug (URL)</label>
        <input class="input" name="slug" value="<?= h($p['slug'] ?? '') ?>" placeholder="auto si vacío">

        <label class="label">Categoría</label>
        <select class="input" name="category_id">
          <option value="">—</option>
          <?php foreach ($cats as $c): ?>
            <option value="<?= (int)$c['id'] ?>" <?= ((int)($p['category_id'] ?? 0) === (int)$c['id']) ? 'selected' : '' ?>><?= h($c['name']) ?></option>
          <?php endforeach; ?>
        </select>

        <label class="label">Precio base</label>
        <input class="input" name="price" type="number" step="0.01" value="<?= h($p['price'] ?? 0) ?>">

        <label class="check">
          <input type="checkbox" name="is_active" <?= !isset($p['is_active']) || $p['is_active'] ? 'checked' : '' ?>>
          <span>Activo</span>
        </label>

        <label class="label">Descripción</label>
        <textarea class="input" name="description" rows="7"><?= h($p['description'] ?? '') ?></textarea>
      </div>

      <div>
        <div class="panel">
          <div class="panel-title">Imágenes (URLs)</div>
          <div class="muted">Podés pegar links directos (jpg/png/webp). Se muestran en la galería.</div>
          <div id="imgList">
            <?php $n = max(3, count($imgs)); for ($i=0; $i<$n; $i++): $u = $imgs[$i]['url'] ?? ''; ?>
              <input class="input" name="img_url[]" value="<?= h($u) ?>" placeholder="https://...">
            <?php endfor; ?>
          </div>
          <button class="btn btn-ghost" type="button" onclick="addImg()">+ Agregar imagen</button>
        </div>

        <div class="panel">
          <div class="panel-title">Variantes (talle/color/stock)</div>
          <div class="muted">Si no usás variantes, dejalo vacío.</div>

          <div class="variants">
            <div class="tr th">
              <div>SKU</div><div>Color</div><div>Talle</div><div>Precio</div><div>Stock</div>
            </div>
            <?php $m = max(2, count($vars)); for ($i=0; $i<$m; $i++): $v = $vars[$i] ?? []; ?>
              <div class="tr">
                <div><input class="input input-sm" name="var_sku[]" value="<?= h($v['sku'] ?? '') ?>"></div>
                <div><input class="input input-sm" name="var_color[]" value="<?= h($v['color'] ?? '') ?>"></div>
                <div><input class="input input-sm" name="var_size[]" value="<?= h($v['size'] ?? '') ?>"></div>
                <div><input class="input input-sm" name="var_price[]" value="<?= h($v['price'] ?? '') ?>" placeholder="opcional"></div>
                <div><input class="input input-sm" name="var_stock[]" value="<?= h($v['stock'] ?? 0) ?>"></div>
              </div>
            <?php endfor; ?>
          </div>
          <button class="btn btn-ghost" type="button" onclick="addVar()">+ Agregar variante</button>
        </div>
      </div>
    </div>

    <div class="btn-row">
      <button class="btn" type="submit">Guardar</button>
      <?php if (!empty($p['id'])): ?>
        <form method="post" action="/admin/products/delete" onsubmit="return confirm('¿Eliminar producto?')">
          <input type="hidden" name="_csrf" value="<?= h(csrf_token($config)) ?>">
          <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
          <button class="btn btn-danger" type="submit">Eliminar</button>
        </form>
      <?php endif; ?>
    </div>
  </form>
</main>

<script>
function addImg() {
  const el = document.createElement('input');
  el.className = 'input';
  el.name = 'img_url[]';
  el.placeholder = 'https://...';
  document.getElementById('imgList').appendChild(el);
}
function addVar() {
  const row = document.createElement('div');
  row.className = 'tr';
  row.innerHTML = `
    <div><input class="input input-sm" name="var_sku[]"></div>
    <div><input class="input input-sm" name="var_color[]"></div>
    <div><input class="input input-sm" name="var_size[]"></div>
    <div><input class="input input-sm" name="var_price[]" placeholder="opcional"></div>
    <div><input class="input input-sm" name="var_stock[]" value="0"></div>
  `;
  document.querySelector('.variants').appendChild(row);
}
</script>

<?php include __DIR__ . '/../partials/footer.php'; ?>
