<?php $title = 'Carrito - ' . $config['app_name']; include __DIR__ . '/../partials/head.php'; ?>
<?php include __DIR__ . '/../partials/header.php'; ?>

<main class="container page">
  <h1>Carrito</h1>

  <?php if ($err = flash_get('error')): ?>
    <div class="alert alert-error"><?= h($err) ?></div>
  <?php endif; ?>

  <?php if (!$items): ?>
    <div class="empty">
      <div class="empty-title">Tu carrito está vacío</div>
      <a class="btn" href="/">Volver a la tienda</a>
    </div>
  <?php else: ?>
    <form action="/cart/update" method="post">
      <input type="hidden" name="_csrf" value="<?= h(csrf_token($config)) ?>">
      <div class="cart">
        <div class="cart-items">
          <?php foreach ($items as $it): ?>
            <div class="cart-row">
              <div class="cart-img" style="background-image:url('<?= h($it['img'] ?: '/public/assets/placeholder.jpg') ?>')"></div>
              <div>
                <div class="cart-title"><?= h($it['product']['name']) ?></div>
                <?php if ($it['variant']): ?>
                  <div class="muted"><?= h(trim(($it['variant']['color'] ?? '').' '.($it['variant']['size'] ?? ''))) ?></div>
                <?php endif; ?>
                <div class="muted"><?= h(money_ars($it['unit'])) ?> c/u</div>
              </div>
              <div>
                <input class="input input-sm" type="number" min="0" name="qty[<?= h($it['key']) ?>]" value="<?= (int)$it['qty'] ?>">
              </div>
              <div class="cart-line"><?= h(money_ars($it['line'])) ?></div>
            </div>
          <?php endforeach; ?>
        </div>

        <aside class="cart-sum">
          <div class="sum-row"><span>Subtotal</span><span><?= h(money_ars($subtotal)) ?></span></div>
          <div class="sum-row total"><span>Total</span><span><?= h(money_ars($subtotal)) ?></span></div>
          <button class="btn btn-wide" type="submit">Actualizar</button>
          <a class="btn btn-ghost btn-wide" href="/checkout">Finalizar compra</a>
          <div class="note">Si ponés cantidad 0, se elimina.</div>
        </aside>
      </div>
    </form>
  <?php endif; ?>
</main>

<?php include __DIR__ . '/../partials/footer.php'; ?>
