<?php $title = $config['app_name'] . ' - Home'; include __DIR__ . '/../partials/head.php'; ?>
<?php include __DIR__ . '/../partials/header.php'; ?>

<main>
  <section class="hero">
    <div class="container hero-inner">
      <div class="hero-copy">
        <h1>Nueva colección</h1>
        <p>Estilo editorial, grillas limpias y experiencia rápida. Todo en PHP + SQLite.</p>
        <div class="hero-ctas">
          <a class="btn" href="/c/mujer">Descubrir ahora</a>
          <a class="btn btn-ghost" href="/admin/import">Importar desde API</a>
        </div>
      </div>
      <div class="hero-card">
        <div class="hero-card-title">Categorías</div>
        <div class="cats">
          <?php foreach ($cats as $c): ?>
            <a class="cat" href="/c/<?= h($c['slug']) ?>"><?= h($c['name']) ?></a>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </section>

  <section class="section">
    <div class="container">
      <div class="section-head">
        <h2>Novedades</h2>
        <a class="link" href="/search?q=">Ver todo</a>
      </div>

      <?php if (!$new): ?>
        <div class="empty">
          <div class="empty-title">Todavía no hay productos.</div>
          <div class="empty-sub">Entrá al Admin → Importar, pegá la URL de tu API y traemos el catálogo.</div>
          <a class="btn" href="/admin/import">Ir a Importar</a>
        </div>
      <?php else: ?>
        <div class="grid">
          <?php foreach ($new as $p): 
            $img = $db->prepare("SELECT url FROM product_images WHERE product_id=? ORDER BY sort_order ASC LIMIT 1");
            $img->execute([$p['id']]);
            $img = $img->fetchColumn();
          ?>
          <a class="card" href="/p/<?= h($p['slug']) ?>">
            <div class="card-img" style="background-image:url('<?= h($img ?: '/public/assets/placeholder.jpg') ?>')"></div>
            <div class="card-body">
              <div class="card-title"><?= h($p['name']) ?></div>
              <div class="card-price"><?= h(money_ars($p['price'])) ?></div>
            </div>
          </a>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div>
  </section>
</main>

<?php include __DIR__ . '/../partials/footer.php'; ?>
